package net.w_horse.excelpojo.xml;

import static org.junit.Assert.assertEquals;

import java.io.FileInputStream;
import java.io.IOException;

import net.w_horse.excelpojo.AbstractTest;
import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.excel.CellNotFoundException;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Test;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import test.xml.XMLTest;
import test.xml.XMLTestElement;

public class LabeledCellTest extends AbstractTest {
	/**
	 * xɂʒuɑ΂Af[^擾ʒuiretrieveFrom=rightj̓eXg
	 *
	 */
	@Test
	public void testReadAndSaveLabeledCellRetrieveFromRight() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/testReadAndSaveLabeledCell.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveLabeledCellRetrieveFromRight");
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "xǂݍ݈ʒu");

		assertEquals("{i擾jFLabeledCellFString", "Ẽf[^", targetBean.getStringField4LabeledCell1());

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"xǂݍ݈ʒu",
				"./files/export/XMLParserTest_xǂݍ݈ʒuiEj.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_xǂݍ݈ʒuiEj.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("xǂݍ݈ʒu");

			assertEquals("{i݁jFLabeledCellFString", "Ẽf[^", getCellValue(sheet, 4, 4, CELL_TYPE_STRING));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * xɂʒuɑ΂Af[^擾ʒuiretrieveFrom=downj̓eXg
	 *
	 */
	@Test
	public void testReadAndSaveLabeledCellRetrieveFromBottom() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/testReadAndSaveLabeledCell.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveLabeledCellRetrieveFromBottom");
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "xǂݍ݈ʒu");

		assertEquals("{i擾jFLabeledCellFString", "̃f[^", targetBean.getStringField4LabeledCell1());

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"xǂݍ݈ʒu",
				"./files/export/XMLParserTest_xǂݍ݈ʒuij.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_xǂݍ݈ʒuij.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("xǂݍ݈ʒu");

			assertEquals("{i݁jFLabeledCellFString", "̃f[^", getCellValue(sheet, 5, 3, CELL_TYPE_STRING));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * xɂʒuɑ΂Af[^擾ʒuiretrieveFrom=leftj̓eXg
	 *
	 */
	@Test
	public void testReadAndSaveLabeledCellRetrieveFromLeft() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/testReadAndSaveLabeledCell.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveLabeledCellRetrieveFromLeft");
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "xǂݍ݈ʒu");

		assertEquals("{i擾jFLabeledCellFString", "̃f[^", targetBean.getStringField4LabeledCell1());

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"xǂݍ݈ʒu",
				"./files/export/XMLParserTest_xǂݍ݈ʒuij.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_xǂݍ݈ʒuij.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("xǂݍ݈ʒu");

			assertEquals("{i݁jFLabeledCellFString", "̃f[^", getCellValue(sheet, 4, 2, CELL_TYPE_STRING));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * ꂽxɂf[^擾imargedLabelj̓eXg
	 *
	 */
	@Test
	public void testReadAndSaveLabeledCellMargedLabel() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/testReadAndSaveLabeledCell.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveLabeledCellMargedLabel");
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "Users2");

		assertEquals("{i擾jFLabeledCellFString", "Xg", targetBean.getStringField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFString", "ExcelPOJỎ", targetBean.getStringField4PointedCell1());
		assertEquals("{i擾jFLabeledCellFString", "XgiQj", targetBean.getStringField4ConstantValue1());

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"Users2",
				"./files/export/XMLParserTest_xA.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_xA.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("Users2");

			assertEquals("{i݁jFLabeledCellFString", "Xg", getCellValue(sheet, 1, 2, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFString", "ExcelPOJỎ", getCellValue(sheet, 2, 2, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFString", "XgiQj", getCellValue(sheet, 1, 5, CELL_TYPE_STRING));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * x̓ǂݍ݂ɕK{wiuse=requiredjw肵ۂ̓eXg
	 * K{Y\Ȃꍇ˗O
	 */
	@Test(expected=CellNotFoundException.class)
	public void testReadAndSaveLabeledCellUseRequired() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/testReadAndSaveLabeledCell.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveLabeledCellUseRequired");
		@SuppressWarnings("unused")
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "xǂݍ݈ʒu");
	}

	/**
	 * ͈͎w茟̃eXg
	 * xɑ΂w̏ꍇiK{ɂĂ̂Ōsv̏ꍇ͗Oj
	 * @throws ExcelPOJOException
	 */
	@Test(expected=CellNotFoundException.class)
	public void testRangeLabeledCell() throws ExcelPOJOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/testReadAndSaveLabeledCell.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testRangeLabeledCell");
		@SuppressWarnings("unused")
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "{");
	}

	/**
	 * ͈͎w茟̃eXg
	 * x̎w肪󔒂ꍇ
	 * @throws Exception
	 */
	@Test(expected=ExcelPOJOException.class)
	public void testLabeledCellLabelBlank() throws Exception {
		try {
			ApplicationContext context = new ClassPathXmlApplicationContext("./config/testReadAndSaveLabeledCell.xml");
			ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testLabeledCellLabelBlank");
			@SuppressWarnings("unused")
			XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "{");
		} catch (Exception e) {
			assertEquals("x̎w肪󔒂ꍇ",
					"java.lang.IllegalArgumentException: The label is not specified.",
					e.getMessage());
			throw e;
		}
	}

	/**
	 * sȒ`̃eXg
	 * LabeledCell:retrieveFromɕsȒlw
	 * XML̏G[
	 * @throws ExcelPOJOException
	 */
	@Test(expected=BeanDefinitionStoreException.class)
	public void testLabeledCellInvalidRetrieveFrom() throws ExcelPOJOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTestsInvalidRangeInvalidRetrievFrom.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testLabeledCellInvalidRetrieveFrom");
		@SuppressWarnings("unused")
		XMLTestElement targetBean = (XMLTestElement) bridge.load("./files/upload/ParserTest.xls", "{");
	}

}
